/* Adobe.Breathe.js -- Breathe behavior for Animal */

define(["lib/Zoot", 
	"lodash", "lib/dev", "lib/tasks"],
function (Z, 
	lodash, dev, tasks) {
	"use strict";

	return {
		about: "$$$/private/animal/Behavior/Breathe/About=Breathe behavior",
		description: "$$$/animal/Behavior/Breathe/Desc=Smoothly grows and shrinks Breathe handles to look like breathing",
		uiName: "$$$/animal/Behavior/Breathe/UIName=Breathe",
		defaultArmedForRecordOn: true,
		
		defineParams: function () { // free function, called once ever; returns parameter definition (hierarchical) array
			return [
				{ id: "targetHandles", type: "handle", uiName: "$$$/animal/Behavior/Breathe/Parameter/targetHandles=Breathe Handles", dephault: { match: "//Adobe.Breathe.Chest"} },
				{ id: "rate", type: "slider", uiName: "$$$/animal/Behavior/Breathe/Parameter/rate=Breaths per Minute", precision: 1, dephault: 40, "min": 0, "max": 500 },
				{ id: "maxScale", type: "slider", uiName: "$$$/animal/Behavior/Breathe/Parameter/maxScale=Max Scale", precision: 1, uiUnits: "%", dephault: 400 },
				{ id: "minScale", type: "slider", uiName: "$$$/animal/Behavior/Breathe/Parameter/minScale=Min Scale", precision: 1, uiUnits: "%", dephault: 100 },
				{ id: "moveOffset", type: "slider", uiName: "$$$/animal/Behavior/Breathe/Parameter/moveOffset=Offset", precision: 1, dephault: 0, "min": 0, "max": 5000,
					uiToolTip: "$$$/animal/Behavior/Breathe/Parameter/moveOffset/ToolTip=Distance to move Breathe handles when breathing in" },
				{ id: "moveDirection", type: "angle", uiName: "$$$/animal/Behavior/Breathe/Parameter/moveDirection=Direction", precision: 0, dephault: 0,
					uiToolTip: "$$$/animal/Behavior/Breathe/Parameter/moveDirection/ToolTip=Direction to move Breathe handles when breathing in" }
			];
		},

		defineTags: function () {
			return { 
				aTags: [
					{
						id: "Adobe.Breathe.Chest",
						artMatches: ["chest", "breathe"],
						uiName: "$$$/animal/Behavior/Breathe/TagName/Breathe=Breathe",
						tagType: "handletag"
					}
				]
			};
		},

		onCreateBackStageBehavior: function () {
		},

		onCreateStageBehavior: function (self, args) {
			self.targetHandles = args.getStaticParam("targetHandles");
		},

		onAnimate: function (self, args) { // method on behavior that is attached to a puppet, only onstage		
			var s, osc, pos, angle, rad, minScale, maxScale, rate, dist, t = args.t + args.globalRehearseTime;
			
			if (self.targetHandles.length === 0) {
				return;
			}

			minScale = args.getParam("minScale") * 0.01;
			maxScale = args.getParam("maxScale") * 0.01;
			dist = args.getParam("moveOffset");
			angle = args.getParam("moveDirection");
			
			rate = args.getParam("rate");

			self.lastT = self.lastT || t;
			self.phase = self.phase || 0;

			self.phase += (t-self.lastT)*(rate/60)*Math.PI*2;
			self.lastT = t;
			osc = ((Math.sin(self.phase)+1)*0.5);
			s = osc * (maxScale-minScale) + minScale;
			pos = [0, osc*(-dist)];
			rad = (angle * Math.PI*2) / 360.0;

			var tformBreathe = {
				xScale : s, yScale : s
			};

			if (dist > 0) {
				// only set translation to manual if we're offsetting the distance; this is a temporary solution to
				//	fix 4033447 without fully reintroducing 3999892. TODO: create API that lets behaviors set transforms
				//	in either local or global space, without reading current matrix values and adjusting them -- for
				//	Breathe we always want the offset to be local (e.g. if we're breathing "up", it should be toward the head even
				//	if the whole body is rotated 90 degrees to the side by pulling an arm). Face wants similar behavior for Head.

				Z.Vec2.transformAffine(Z.Mat3.rotation(rad), pos, pos);
				tformBreathe.x = pos[0];
				tformBreathe.y = pos[1];
			}

			var breathe = new tasks.MoveTo(tformBreathe);
			// FIXME (jovan): simplify syntax for 3rd parties
			var attachBreathe = lodash(tasks.handle.attachTask).partialRight(breathe, 1).ary(1).value();
			self.targetHandles.forEach(attachBreathe);

		}

	}; // end of object being returned
});
